// ---------------------------------------------------------------------
//  ngh1.inc
//
//  upper wall is 20 feet house to steps 
//  upper wall overlaps house extension by 28inches
//  lower planter is 11f2i ns  7f3i ew
//
//  upper wall 9f6i ns to inner edge of ew steps  
//  upper wall to edge of steps, planter overlaps
//  ew steps are 8f1i

//  datum - centerline ground, x = west edge of greenhouse concrete

#declare r2d= 45.0 / atan2( 1.0, 1.0 );

#declare StepWood   = color rgbt < 0.78, 0.70, 0.49, 0.00 > ;
#declare TerraCotta = color rgbt < 0.90, 0.50, 0.20, 0.00 > ;
#declare WallColor  = color rgbt < 0.90, 0.85, 0.65, 0.00 > ;
#declare RoofColor  = color rgbt < 0.70, 0.70, 0.70, 0.00 > ;
#declare FenceColor = color rgbt < 0.58, 0.50, 0.29, 0.00 > ;
#declare InnerColor = color rgbt < 0.50, 0.40, 0.20, 0.00 > ;
#declare GlassColor = color rgbt < 0.00, 0.00, 3.00, 0.90 > ;
#declare Invisible  = color rgbt < 0.00, 0.00, 0.00, 1.00 > ;
#declare Solexx     = color rgbt < 2.00, 2.00, 2.00, 0.80 > ; 
#declare WoodColor  = color rgbt < 0.48, 0.40, 0.19, 0.00 > ;
#declare TreeGreen  = color rgbt < 0.21, 0.84, 0.21, 0.50 > ;

// shed part of greenhouse -----------------------------------------
// outside width 148.5 to  >> 148.0 <<
// inside width: -4 on each wall   140.0

#declare  shns       =  74.0          ; // shed wall north or south
#declare  shpitch    =  3.5 / 12.0    ; // shed roof pitch, 16.26°
#declare  shyd       = shpitch*shns   ; // roof peak increase
#declare  shwx       = -131.0         ; // west end of concrete outside
#declare  shwx0      =  5.0+shwx      ; // west end of wall inside
#declare  shwx1      =  5.75+shwx     ; // west end of concrete inside
#declare  shex       =  16.0          ; // shed east wall

#declare  shwy0      =  74.25         ; // height of concrete at west
#declare  shwy1      = shwy0 - 12.0   ; // height of concrete cut
#declare  shy3       = shwy1 + 88.0   ; // trough of underside roof
#declare  shy2       = shy3 + shyd    ; // top of north and south wall
#declare  shy4       = shy3 + 39.0    ; // shed outer height (before roof cutout)
#declare  shy5       = shy4 + 1.0     ; // shed inner cutout height
#declare  shym       = shy3 + shyd/2  ; // halfway up roof

#declare  shz0       = -shns          ; // concrete south wall outside
#declare  shz1       =  shz0+4        ; // concrete south wall inside
#declare  shz2       = -shz1          ; // concrete north wall inside
#declare  shz3       = -shz0          ; // concrete north wall outside
#declare  shcsy      = 45.0           ; // concrete south wall height
#declare  shcny      = 46.0           ; // concrete north wall height

#declare  shzs       =  shz0 + 24     ; // greenhouse cutout on south
#declare  shzn       = -shzs          ; // greenhouse cutout on north

#declare  shhoop     = 72.0           ; // hoop distance
#declare  shgy2      = 114.0          ; // shed greenhouse cutout middle
// lower prism corners:  pivot        height reduction
#declare  shgy1      = (shgy2-shhoop)+sqrt(shhoop*shhoop-shzs*shzs) ; 

#declare  ash = r2d * atan( shpitch ) ; // roof angle in degrees

// concrete greenouse base -----------------------------------------

#declare  ghcx0      = 0.0            ; // concrete base near datum
#declare  ghcx1      = 180.0+shwx1    ; // concrete dropoff on north wall
#declare  ghcx3      = 386.0          ; // concrete base east outside
#declare  ghcx2      = ghcx3-5.0      ; // concrete base east inside
#declare  ghcsy      = 11.0           ; // concrete base south
#declare  ghcny      = 18.0           ; // concrete base north

// door ------------------------------------------------------------
// origin at hinge, door outwards points south

#declare  doorheight = 80.0 ;
#declare  doorwidth  = 36.0 ;
#declare  doorframe  =  2.0 ;
#declare  doorwindow =  3.0 ;
#declare  doorthick  =  2.0 ;
#declare  doorknob   = 36.0 ;
#declare  doorsill   =  1.0 ;

#declare  drx0 = -doorframe  ;
#declare  drx1 =  0.0        ;
#declare  drx2 =  doorwindow ;
#declare  drx3 =  doorwidth  - doorwindow ;
#declare  drx4 =  doorwidth  ;
#declare  drx5 =  doorwidth  + doorframe  ;

#declare  dry0 =  0.0        ;
#declare  dry1 =  doorsill   ;
#declare  dry2 =  doorsill   + doorknob   ;
#declare  dry3 =  doorsill   + doorknob   + doorwindow  ;
#declare  dry4 =  doorsill   + doorheight - doorwindow  ;
#declare  dry5 =  doorsill   + doorheight               ;
#declare  dry6 =  doorsill   + doorheight + doorframe   ;

#declare  drz0 = -3.0        ;
#declare  drz1 = -doorframe  ;
#declare  drz2 =  0.0        ;
#declare  drz3 =  doorthick  ;
#declare  drz4 =  doorthick  + doorframe ;
#declare  drz5 =  9.0        ;

#declare  dwz1 =  (1/4)*doorthick ;
#declare  dwz2 =  (3/4)*doorthick ;

#declare  dsx  = -38.0          ; // west end of south door
#declare  dsy  =  0.0           ; // west end of south door
#declare  dsz  =  shz0          ; // west end of south door

#declare  dwx  =  shwx          ; // north end of west door
#declare  dwy  =  shwy1         ; // north end of west door
#declare  dwz  =  shz3-24.0     ; // north end of west door
#declare  dwzs =  dwz - drx5    ; // south end of west door

#declare  dex  =  ghcx2         ; // north end of east door
#declare  dey  =  0.0           ; // north end of east door
#declare  dez  = -2.0           ; // north end of east door

#declare  rfw  = shwx - 6.0     ;

#declare door      = union {
  difference {  // door with window cutout
    box { < drx1, dry1, drz2 >, < drx4, dry5, drz3 > }
    box { < drx2, dry3, drz0 >, < drx3, dry4, drz5 > }  // window cutout
    finish { ambient 0.5 diffuse 0.7 } pigment { Gray90 } }

  box { < drx2, dry3, dwz1 >, < drx3, dry4, dwz2 >      // window glass
    pigment { GlassColor } }

  // door frame 
  difference {
    box { < drx0, dry0, drz1 >, < drx5,  dry6, drz4 > }
    box { < drx1, dry1, drz0 >, < drx4,  dry5, drz5 > }
    finish { ambient 0.5 diffuse 0.7 } pigment { Gray80 }
  }

  // doorknob
  cylinder { < drx3, dry2, drz1 >, < drx3, dry2, drz4 >, 1.5
    finish { ambient 0.5 diffuse 0.7 } pigment { Gray40 }
  }

  box { < drx0, dry0, drz0 >, < drx5, dry6, drz5 >       // door cutout area
    pigment { Invisible } }
}

#declare alldoors = union {
  object { door               translate < dsx, dsy, dsz > }
  object { door rotate 90*y   translate < dwx, dwy, dwz > }
  object { door rotate 90*y   translate < dex, dey, dez > }
}

// shed roof -------------

#declare  rfspace   = 12.0           ; // standing seam spacing
#declare  rfnum     = 13             ; // number of standing seam spaces
#declare  rfsm      = 0.5            ; // seam horizontal width
#declare  rfdelta   = rfnum*rfspace  ; // width between west and east seams
#declare  rfw       = shwx - 6.0     ; // west gable end of roof
#declare  rfx0      = rfw            ; // outer west gable end
#declare  rfx1      = rfx0 + 1.5     ; // inner west standing seam
#declare  rfx2      = rfx0 + 2.0     ; // inner west gable end
#declare  rfws      = rfx1 + rfspace ; // start of standing seam ridges
#declare  rfx3      = rfx1 + rfdelta ; // inner east gable end
#declare  rfx4      = rfx3 + 1.5     ; // inner west gable end
#declare  rfx5      = rfx3 + 2.0     ; // outer east gable end
#declare  rfe       = rfx5           ; // east gable end of roof

#declare  rfy0      = -3.5           ; // bottom of gable/eave
#declare  rfyn      = -0.01          ; // bottom of roof block
#declare  rfy1      =  0.0           ; // bottom of roof panel
#declare  rfy2      =  0.5           ; // top of roof panel
#declare  rfy3      =  1.5           ; // top of gable and seam
#declare  rfy4      =  2.0           ; // top of peak

#declare  rfz0      =  -rfy4*shpitch ; // roof peak before rotation
#declare  rfz1      =  rfz0 + 3.0    ; // roof peak outer
#declare  rfz2      =  rfz1 + 88.5   ; // roof eave inner
#declare  rfz3      =  rfz1 + 90.0   ; // roof eave outer
#declare  rfz4      =  rfz1 + 90.1   ; // roof eave outer

// north panel, unpitched
#declare  rfpanel   = union {
  merge { 
    box { < rfx1, rfy1,  0.0 >, <rfx4, rfy2, rfz3  > }  // base panel
    box { < rfx0, rfy0,  0.0 >, <rfx2, rfy3, rfz3  > }  // west gable
    box { < rfx3, rfy0,  0.0 >, <rfx5, rfy3, rfz3  > }  // east gable
    box { < rfx1, rfy0, rfz2 >, <rfx4, rfy1, rfz4  > }  // north eave

    #declare    rfx = rfws ;                            // seam loop
    #while (    rfx < rfx3 )
      box { <   rfx, rfy2, 0.0 >, < rfx+rfsm, rfy3, rfz3 > }
      #declare  rfx = rfx+rfspace ;
    #end

    finish { ambient 0.5 diffuse 0.7 } pigment { RoofColor }
  }
  // transparent blocking box, used as cutout
  box { < rfw, rfyn, rfz0 >, < rfe, 99, rfz3 > pigment { Invisible } }
}

#declare  roof     = union {
   object { rfpanel                rotate -ash*x }
   object { rfpanel scale <1,1,-1> rotate  ash*x }
   translate shy3*y 
}

// concrete  ----------------------------------------------------------------

#declare concrete = difference {
  box {   < shwx ,  -1.0, shz0>, < ghcx3, shwy0, shz3> } // outer edges

  union {  // cutouts
    box { < shwx1,   0.0, shz1>, < ghcx2,   999, shz2> } // inside walls and floor
    box { < shwx1, shcsy, -99 >, <   999,   999,    0> } // top of southwest wall
    box { < shwx1, shcny,   0 >, <   999,   999,  999> } // top of northwest wall
    box { <   0.0, ghcsy, -99 >, <   999,   999,    0> } // top of southeast wall
    box { < ghcx1, ghcny,   0 >, <   999,   999,  999> } // top of northeast wall
    object { alldoors } 
  }
  normal { bumps 0.5 }
  finish { ambient 0.5 diffuse 0.7 } pigment { LightGray }
}

// shed ----------------------------------------------------------------

/*
#declare  win0w     =  shwx + 20      ;
#declare  win0e     =  shwx + 36      ;
#declare  win1w     =  shwx + 51      ;
#declare  win1e     =  shwx + 67      ;
#declare  win2w     =  shwx + 82      ;
#declare  win2e     =  shwx + 98      ;
#declare  win3w     =  shwx +113      ;
#declare  win3e     =  shwx +129      ;

#declare  winy1     =   54            ;
#declare  winy2     =   80            ;
#declare  winy3     =  110            ;
#declare  winy4     =  shy2-8         ;
*/
 
#declare  win0w     =  shwx + 36      ;
#declare  win0c     =  shwx + 44      ;
#declare  win0e     =  shwx + 52      ;
#declare  win1w     =  shwx +100      ;
#declare  win1c     =  shwx +108      ;
#declare  win1e     =  shwx +116      ;

#declare  winy1     =   54            ;
#declare  winy2     =   80            ;
#declare  winy3     =  128            ;
#declare  winy4     =  shy2-8         ;

#declare  winz0     = -0.6+shz0       ;
#declare  winz1     = -0.5+shz0       ;
#declare  winz2     = -0.1+shz0       ;
#declare  winz3     =  0.1+shz1       ;
#declare  winz4     =  0.5+shz1       ;
#declare  winz5     =  0.6+shz1       ;
#declare  wfr       =  1.0            ;
#declare  wie       =  0.001          ;

#macro  OneWindow ( WXW, WXE, WY0, WY1 )
union {
  difference {   // frame
    box { < WXW-wfr, WY0-wfr, winz1 >, < WXE+wfr, WY1+wfr, winz4 > }
    box { < WXW    , WY0    , winz0 >, < WXE    , WY1    , winz5 > }
    finish { ambient 0.5 diffuse 0.7 } pigment { Gray90 }
  }
  box {    < WXW+wie, WY0+wie, winz2 >, < WXE-wie, WY1-wie, winz3 > 
    pigment { GlassColor } 
  }
}
#end

#macro  CutWindow ( WXW, WXE, WY0, WY1 )
  box { < WXW-wfr, WY0-wfr, winz1 >, < WXE+wfr, WY1+wfr, winz4 > }
#end

#declare shedwindows = union { 
  OneWindow( win0w, win0e, winy1, winy2 )
  OneWindow( win0w, win0e, winy3, winy4 )
  OneWindow( win1w, win1e, winy3, winy4 )
}

#declare cutwindows = union {
  CutWindow( win0w, win0e, winy1, winy2 )
  CutWindow( win0w, win0e, winy3, winy4 )
  CutWindow( win1w, win1e, winy3, winy4 )
}

#declare  shvx1      =  4.0           ; // shed vent cutout west end
#declare  shvx2      =  shex-4.0      ; // shed vent cutout east end
#declare  shvx3      =  shex+1.0      ; // shed vent east end
#declare  shvy1      =  120           ; //
#declare  shvy2      =  150           ; //
#declare  shvz1      =  56            ; //
#declare  shvz2      =  26            ; //
#declare  shvz3      = -shvz2         ; //
#declare  shvz4      = -shvz1         ; //
#declare  shvs       =  shzs+1.0      ; // vent cutout on south
#declare  shvn       = -shvs          ; // vent cutout on north

#declare shedvents = union {  
  box{ < shvx1, shvy1, shvz1 > , < shvx3, shvy2, shvz2 > }
  box{ < shvx1, shvy1, shvz3 > , < shvx3, shvy2, shvz4 > }
  finish { ambient 0.5 diffuse 0.7 } pigment { Gray30 }
}

// shed floor ------------------------------------------

#declare flx1 = shwx1 ;
#declare flx2 = flx1+30 ;  // edge of steps
#declare flx3 = flx1+34 ;  // edge of step wall
#declare flx4 = -50     ;
#declare flx5 = flx4+ 4 ;
#declare flx6 = -9.0  ;
#declare flx7 =  0.0  ;
#declare flx8 =  6.0  ;

#declare fly1 = dwy-4 ;    // lower floor bottom
#declare fly2 = dwy   ;    // lower floor top
#declare fly3 = 82    ;    // upper floor bottom
#declare fly4 = 86    ;    // upper floor top

#declare flz1 = shz2  ;    // north wall
#declare flz2 = dwzs-2;    // north side of vertical
#declare flz3 = flz2-4;    // south side of vertical
#declare flz4 = shz1  ;    // south wall

#declare shedfloor = union {
  box { < flx1, fly1, flz1 >, < flx4, fly2, flz3 > } // north floor lower
  box { < flx2, fly1, flz2 >, < flx4, fly4, flz3 > } // ew vertical
  box { < flx2, fly3, flz2 >, < flx4, fly4, flz4 > } // south floor middle upper
  box { < flx5, fly1, flz3 >, < flx4, fly4, flz1 > } // ns vertical
  box { < flx4, fly3, flz1 >, < flx7, fly4, flz4 > } // ns floor east  upper
  finish { ambient 0.5 diffuse 0.7 } pigment { StepWood }
}

#declare stpx  = 24.0 ;  // step width
#declare stpy  =  2.0 ;  // step board thickness
#declare stpz  = 11.0 ;  // step board depth
#declare stpt  = 10.0 ;  // step tread
// #declare stpr  =  8.0 ;  // step rise
#declare stpr  = (fly4-fly2)/3.99 ;  // step rise

#declare innersteps = union {
  #declare stpz0 = flz3 + 1.0  ;
  #declare stpy0 = fly2 + stpr ;
  #while ( stpy0 < fly4 ) 
    #declare stpz1 = stpz0 - stpz ;
    #declare stpy1 = stpy0 - stpy ;
    box { < flx1, stpy0, stpz0 >,  < flx2, stpy1, stpz1 > }  // step riser
    #declare stpz0 = stpz0 - stpt ;
    #declare stpy0 = stpy0 + stpr ;
  #end
  box {   < flx1,  fly3, stpz0 >,  < flx2,  fly4,  flz4 > }  // landing
  finish { ambient 0.5 diffuse 0.7 } pigment { StepWood }
}

#declare floorwall = union {  // cutout
  box { < flx6, -1.0, flz3 >, < flx8, fly1, shzn > }
  box { < flx6, -1.0, flz3 >, < flx8, fly3, shzs > }
  finish { ambient 0.5 diffuse 0.7 } pigment { InnerColor }
}


#declare shed = difference {
  box {     < shwx, -0.1, shz0>, <   shex, shy4, shz3 >   // outer box
    finish { ambient 0.5 diffuse 0.7 } pigment { WallColor } }

  // cut holes in the outer box
  union {
    box { < shwx1, -1.0, shz1>, <    -0.1, shy5, shz2 > } // inner box
    box { < shvx1, -1.0, shvn>, <   shvx2, shy5, shvs > } // vent  box
    object { concrete translate < -0.1,0,-0.1 > }
    object { concrete translate < -0.1,0, 0.1 > }
    object { concrete translate <  0.1,0,-0.1 > }
    object { concrete translate <  0.1,0, 0.1 > }
    object { roof        }
    object { alldoors    }
    object { cutwindows  }
    object { shedvents   }
    object { floorwall   }

    // prism hole for greenhouse
    prism { linear_sweep   linear_spline -20.0, 0.0, 6,
          < shgy2,  0.0 >,    // peak
          < shgy1, shzn >,    // upper north
          <  -1.0, shzn >,
          <  -1.0, shzs >,
          < shgy1, shzs >,    // upper south
          < shgy2,  0.0 >     // peak
      rotate 90*z
    }
    finish { ambient 0.5 diffuse 0.7 } pigment { InnerColor }
  }
}

#declare lity1 = fly3-2 ;
#declare lity2 = shym-2 ;

#declare oneshedlight = union {
  difference {
    box { <-1.0,-0.1,-1.0>, < 1.0, 0.2, 1.0> }  // "lampshade" 
    box { <-0.8,-1.0,-0.8>, < 0.8, 0.1, 0.8> }
    pigment { Black } }
  light_source { < 0, 0, 0> color rgb 0.05 }
}

#declare shedlights = union {
  object { oneshedlight translate < -65, lity2, 36> }
  object { oneshedlight translate < -65, lity2,-36> }
  object { oneshedlight translate < -65, lity1,-36> }
}

// lawn  --------------------------------------------------------------------

#declare lawn = union {
  // lower lawn
  box { < -2000, -1, -4000>, < 2000, -0.1, 120> pigment { SpringGreen }
    normal { bumps 0.3 } finish { ambient 0.2 diffuse 0.7 } }

  // upper lawn
  difference{
  box { < -131, 60.0, -299>, < -1400,  -1,  120> }
    union { 
      box { < -230, 53.3,   -96>, <    0,  99, -999> }
      box { < -231, -1.0,  -170>, <    0,  99, -999> }
      box { < -139, -1.0,   -74>, <    0,  99, -999> }
    } 
    normal { bumps 0.3 }
    finish { ambient 0.2 diffuse 0.7 } pigment { SpringGreen }
  }
}

#declare hedgefence = union {
  // hedge 
  box { <   40, -1.0,  119>, < -900, 160, 150>
    normal { bumps 1.5 }
    finish { ambient 0.5 diffuse 0.7 } pigment { ForestGreen } }

  // northeast fence
  box { <   40,  0.0,  120>, < 2000,  80, 124>
    normal { bumps 0.1 }
    finish { ambient 0.1 diffuse 0.7 } pigment { FenceColor  } }

  // north neighbor fence
  box { <   40,  0.0,  121>, <   44,  80, 900>
    normal { bumps 0.1 }
    finish { ambient 0.1 diffuse 0.7 } pigment { FenceColor  } }

  // north neighbor lawn
  box { < -2000, 24.0,  122>, < 2000, -10, 9999>
    normal { bumps 0.3 }
    finish { ambient 0.1 diffuse 0.7 } pigment { SpringGreen } }
}

// steps --------------------------------------------------------------------

#declare woodstep =
  box { <  -7.5, 7.0, -96.0> , < -0.0, -0.0, 0.0> pigment { StepWood  }
    normal { bumps 0.1 } finish { ambient 0.4 diffuse 0.7 } }

  // south shed steps
#declare step = union {
  box { < -16.0, 6.5, -96.0> , < -7.4, -1.0, 0.0> pigment { SpringGreen }
    normal { bumps 0.1 } finish { ambient 0.2 diffuse 0.7 } }
  object { woodstep }
}

#declare nswoodstep = object { woodstep rotate y*90 }
#declare nsstep     = object {     step rotate y*90 }

#declare ewsteps = union {
  object {     step translate <  -40.0,  0.0, 0.0 > }
  object {     step translate <  -54.0,  6.7, 0.0 > }
  object {     step translate <  -68.0, 13.3, 0.0 > }
  object {     step translate <  -82.0, 20.0, 0.0 > }
  object {     step translate <  -96.0, 26.7, 0.0 > }
  object {     step translate < -110.0, 33.3, 0.0 > }
  object {     step translate < -124.0, 40.0, 0.0 > }
  // south shed step wall     <x, -y >
  prism { linear_sweep linear_spline  -12.0, -19.5, 6,
    <-40,0>, <-40,-8>, <-138,-54> <-250,-54> <-250,0>, <-40,0> 
    normal { bumps 0.1 }
    pigment { StepWood } finish { ambient 0.4 diffuse 0.7 } 
    rotate 90*x translate -84*z
  }
}

#declare allsteps = union {
  object { ewsteps  translate -73*z }
  object { ewsteps  rotate -90*y scale <1,1,-1> translate <-242, 0, -319> }
  object { woodstep translate < -138.0, 46.7, -73.0 > }
  object { woodstep translate < -229.0, 53.3, -96.0 > }

  merge {
    box { <  -236.5, 60.3, -299.9> , < -229.0, -1.0,  -96.0> }
    box { <  -600.5, 60.4, -300.0> , < -229.1, -1.0, -294.0> } 
    normal { bumps 0.1 } pigment { StepWood }
    finish { ambient 0.4 diffuse 0.7 }
  }

  object { woodstep rotate -90*y translate < -235.5, 53.3, -96.0 > }

  // SW corner block
  box { < -140, 60, -73 >, < -130.5, 0.0, -97.0 >
    normal { bumps 0.7 }
    pigment { Gray } finish { ambient 0.2 diffuse 0.7 } 
  }
  union {
    // planter 
    merge { box { < -44, -1, -19>, <-140.1,12,-152> }
            box { < -80,  0, -19>, <-140.0,28,-116> }
            finish { ambient 0.4 diffuse 0.7 } pigment { StepWood } }
    merge { box { < -52, 10, -27>, <-132.0,14,-148> }
            box { < -88, 26, -27>, <-132.0,30,-112> }
            normal { bumps 1.5 }
            finish { ambient 0.5 diffuse 0.7 } pigment { Green } }
    translate (-96-61)*z+2*x
  }
}

// waterdoor and frontvent  ---------------------------------------------

#declare wda  = 140.0      ; // water door open angle
#declare wdx  =  24.0      ; // water door width
#declare wdy  =  16.0      ; // water door height
#declare wdz  =   3.0      ; // water door thick
#declare fvy  =   6.0      ; // front vent height
#declare fvz  =   2.0      ; // front vent thick

#declare fvx0 = shex       ; // west end of water door
#declare fvx1 = fvx0 + 1.0 ; // water door west trim
#declare fvx2 = fvx1 + wdx ; // east end of water door
#declare fvx3 = fvx2 + 1.0 ; // east of water door trim, west end of vent
#declare fvx4 = ghcx3      ; // east end of vent

// #declare fvy0 = ghcsy      ; // bottom of water door and front vent
#declare fvy0 = 11.0       ; // bottom of water door and front vent
#declare fvy1 = fvy0 + 1.0 ; // water door top of bottom trim
#declare fvy2 = fvy1 + wdy ; // water door height
#declare fvy3 = fvy2 + 1.0 ; // top of water door trim
#declare fvy4 = fvy0 + fvy ; // front vent height

#declare fvz1 = shz0       ; // front of water door trim
#declare fvz0 = shz0 - 0.1 ; // front of water door cutout
#declare fvz2 = fvz1 + wdz ; // back of water door trim
#declare fvz3 = fvz2 + 0.1 ; // back of water door cutout
#declare fvz4 = shz0 + 0.1 ; // front of vent
#declare fvz5 = fvz4 + fvz ; // back of vent

#declare waterdoor = union { 
  difference { // frame
    box { < fvx0, fvy0, fvz1 >, < fvx3, fvy3, fvz2 > }
    box { < fvx1, fvy1, fvz0 >, < fvx2, fvy2, fvz3 > }
    finish { ambient 0.5 diffuse 0.7 } pigment { Gray80 } }
  box {   < 0.0,0.0,0.0 >, < wdx, -wdy, wdz >     // door 
    rotate wda*x translate < fvx1, fvy2, fvz1 > 
    finish { ambient 0.5 diffuse 0.7 } pigment { Gray90 } }
} 
  
#declare waterdoorcut = box { < fvx0, fvy0, fvz1 >, < fvx3, fvy3, fvz2 > }

#declare frontvent    = box { < fvx3, fvy0, fvz4 >, < fvx4, fvy4, fvz5 >
                              pigment { rgbt < 0.00, 0.00, 0.00, 0.70 > } } 

// greenhouse ---------------------------------------------------------------
// centerline 0.0

#declare gx =       16.8 ;  // step for hoops, incr. from 16.75
#declare gt =      120.0 ;
#declare gw =       73.0 ;
#declare gn =       71.0 ;
#declare gn0=       69.7 ;
#declare gy =      gt-gn ;
#declare rf = sqrt( gw*gw+gy*gy ) ;
#declare ar = r2d*atan2( gy, gw ) ;        // roof angle degrees

#declare hx0 = ghcx2+2 ;
#declare hx1 =    shex ;
#declare hdx =    23.0 ;  // hoop step ( 46 inch panels )

#declare hy0 =     0.0 ;
#declare hy1 =    48.0 ;
#declare hy2 =   120.0 ;                       // height 

#declare hyd =    dry6 ;   // top of door

#declare hz0 =    72.0 ;                      // hoop center
#declare hz1 =   hz0+9 ;                      // hoop box

#declare hr0 =     0.7 ;    // hoop radius
#declare hr1 =     hz0 ;

#declare hys =  (hy2-hy1)/hr1 ;
#declare hx  =      hx0 ; 

#declare hoop1 = merge {  // white PVC hoop
  cylinder{ <  0, hy0,  hz0 >, < 0, hy1,  hz0 >, hr0 }
  cylinder{ <  0, hy0, -hz0 >, < 0, hy1, -hz0 >, hr0 }
  intersection {
    box  {  < -9, hy1,  hz1 >, < 9, hy2+9, -hz1 > }
    torus{ hr1, hr0 rotate 90*z scale < 1, hys, 1 > translate hy1*y }
  }
}

// east pillars
#declare  ez0 = hz0 - hdx ;
#declare  ey0 = hy1 + hys*sqrt( hz0*hz0 -ez0*ez0 ) ;
#declare  ez1 = ez0 - hdx ;
#declare  ey1 = hy1 + hys*sqrt( hz0*hz0 -ez1*ez1 ) ;

#declare hoops = union {  // white PVC hoop 
  // hoop loop
  difference {
    union {
      #while ( hx > hx1 )
        object { hoop1 translate hx*x }
        #declare hx = hx - hdx ;
      #end
      object {   hoop1 translate (shex+2)*x }
    }
    object { waterdoorcut }
  }

  // east wall pipes 
  // FIXME, we will need more strength against east-west winds

  cylinder{ <  hx0, hy0, -ez0 >, < hx0, ey0, -ez0 >, hr0 } 
  cylinder{ <  hx0, hyd, -ez1 >, < hx0, ey1, -ez1 >, hr0 } 
  cylinder{ <  hx0, hyd,    0 >, < hx0, hy2,    0 >, hr0 } 
  cylinder{ <  hx0, hy0,  ez1 >, < hx0, ey1,  ez1 >, hr0 } 
  cylinder{ <  hx0, hy0,  ez0 >, < hx0, ey0,  ez0 >, hr0 } 

  finish { ambient 0.5 diffuse 0.7 } pigment { White }
}

// pipe tree, 8 foot centers
#declare pr0 =   1.2 ;           // structural pipe radius
#declare prd =  pr0 + hr0 ;      // pipe + hoop radius
#declare pxm =   8.0 ;
#declare px0 =   0.0 ;
#declare pxd =  96.0 ;
#declare px1 = px0 + pxd ;
#declare px2 = px1 + pxd ;
#declare px3 = px2 + pxd ;
#declare px4 = ghcx2     ;
#declare pxe = ghcx2 - 2 ;

#declare py0 = hy1       ;
#declare pz0 = hz0 - prd ;
#declare pz1 = 0.5 * pz0 ;
#declare py1 = hy1 + hys*sqrt( pz0*pz0 -pz1*pz1 ) ;
#declare py2 = hy2 - prd ;
#declare py3 = py1 - sqrt( 47.5*47.5 - pz1*pz1  ) ;

#declare pipetree = merge {  // repurposed pipe structure
   
   // horizontal pipes 

  cylinder{ <  pxm, py0, -pz0 >, < px4, py0, -pz0 >, pr0 } 
  cylinder{ <  pxm, py1, -pz1 >, < px4, py1, -pz1 >, pr0 } 
  cylinder{ <  pxm, py2,    0 >, < px4, py2,    0 >, pr0 } 
  cylinder{ <  pxm, py1,  pz1 >, < px4, py1,  pz1 >, pr0 } 
  cylinder{ <  pxm, py0,  pz0 >, < px4, py0,  pz0 >, pr0 } 
 
  // vertical pipes

  cylinder{ < px0,    0, -pz0 >, < px0, py0, -pz0 >, pr0 } // southwest pipe
  cylinder{ < pxe,    0, -pz0 >, < pxe, py0, -pz0 >, pr0 } // southeast pipe
  cylinder{ < pxe,    0,  pz0 >, < pxe, py0,  pz0 >, pr0 } // northeast pipe

  // FIXME there's also a pipe by the east door

   // tree loop
  #declare px = px3   ;
  #while ( px > px1-1 )
    cylinder{ < px,   0,  pz0 >, < px , py0,  pz0 >, pr0 } // north wall
    cylinder{ < px, py1,  pz1 >, < px , py3,    0 >, pr0 } // diagonal
    cylinder{ < px,   0,    0 >, < px , py2,    0 >, pr0 } // center mast
    cylinder{ < px, py1, -pz1 >, < px , py3,    0 >, pr0 } // diagonal
    cylinder{ < px,   0, -pz0 >, < px , py0, -pz0 >, pr0 } // south wall
    #declare px = px - pxd ;
  #end

  // diagonal brace 
  cylinder{ < px2,   0,    0 >, < px3, py2,     0 >, pr0 }
  finish { ambient 0.5 diffuse 0.7 } pigment { Gray40 }
}

// solexx covering --------------------------------------------------

#declare solx0 =  shex  - 2 ; // west end of solexx covering
#declare solx1 =  shex  - 1 ; // 
#declare solx2 =  shex  - 1 ; // 

#declare solx3 =  ghcx3 - 2 ; // 
#declare solx4 =  ghcx3 - 1 ; // 
#declare solx5 =  ghcx3     ; // 

#declare soly0 =  -0.2      ; // 
#declare soly1 =  hy1       ; // 
#declare soly2 =  hyd       ; // top of door
#declare soly3 =  hy2       ; // top of greenhouse cover

#declare solzn =  hz0 + 1   ; //
#declare solzs = -solzn     ; //
#declare solz0 = -doorwidth ; //
#declare solz1 =  0.0       ; //

#declare solyd =  solzn     ; //
#declare solys =  hys       ; //

#declare covering = difference {
  merge { 
    cylinder  { < solx1, 0, 0 >, < solx4, 0, 0 >, solyd 
       scale < 1, solys, 1 > translate soly1*y  }
    box { < solx1, soly0, solzs >, < solx4, soly1, solzn > }
    pigment { Solexx }
  }
  union { 
    box { < solx0, soly0, solzs >, < solx2, soly3, solzn > }
    box { < solx3, soly0, solz0 >, < solx5, soly2, solz1 > }
    object { waterdoorcut }
    pigment { Invisible }
  }
}

// shelves  -----------------------------------------------

#declare  st0 =         32 ;
#declare  st2 =         40 ;
#declare  st4 =         48 ;
#declare  st5 =         26 ;
#declare  st6 =          4 ;

#declare  sw0 =       shex ;   // west end
#declare  sw1 =         48 ;   // west end middle
#declare  se0 =      ghcx2 ;
#declare  se1 =        328 ;

#declare  sf0 =        -70 ;
#declare  sf1 =        -47 ;
#declare  sf2 =        -25 ;
#declare  sf3 =         25 ;
#declare  sf4 =         47 ;
#declare  sf5 =         70 ;

#declare  sp0 =        -63 ;
#declare  sp1 =        -52 ;
#declare  sp2 =        -18 ;
#declare  sp3 =         -7 ;
#declare  sp4 =          7 ;
#declare  sp5 =         19 ;
#declare  sp6 =         52 ;
#declare  sp7 =         63 ;

#declare  sph =          3 ;   // height of pot
#declare  spb =          2 ;   // radius bottom of pot
#declare  spt =          3 ;   // radius top of pot

#declare  spr =          3 ;   // radius of plant
#declare  spc =          5 ;   // center of plant
#declare  sps =          5 ;   // half spacing of plant

#declare  sb0 =    st0 - 3 ;
#declare  sb2 =    st2 - 3 ;
#declare  sb4 =    st4 - 3 ;
#declare  sb5 =    st5 - 3 ;
#declare  sb6 =    st6 - 3 ;

#declare  plant = union {
  cone { < 0, 0, 0 >, spb   < 0, sph, 0 >, spt
    normal { bumps 0.1 } pigment{ TerraCotta }
    finish { ambient 0.5 diffuse 0.7 } }
  sphere { < 0, spc, 0 >, spr
    normal { bumps 0.9 } finish { ambient 0.5 diffuse 0.7 } pigment { Green } }
}

#declare  shelves = union {
  union {
    box{ < se0, st0, sf0 >, <sw0, sb0, sf1 > }
    box{ < se1, st2, sf2 >, <sw1, sb2, sf3 > }
    box{ < se0, st4, sf4 >, <sw0, sb4, sf5 > }
    box{ < se0, st5, sf4 >, <sw0, sb5, sf5 > }
    box{ < se0, st6, sf4 >, <sw0, sb6, sf5 > }
    normal { bumps 0.1 }
    finish { ambient 0.4 diffuse 0.7 } pigment { StepWood } }

  #declare xx = se0-sps ;                      // glass holder loop
  #while ( xx > sw0+sps )
    object { plant translate < xx, st0, sp0 > }
    object { plant translate < xx, st0, sp1 > }
    object { plant translate < xx, st4, sp6 > }
    object { plant translate < xx, st4, sp7 > }
    #declare xx = xx-2*sps ;
  #end

  #declare xx = se1-sps ;                      // glass holder loop
  #while ( xx > sw1+sps )
    object { plant translate < xx, st2, sp2 > }
    object { plant translate < xx, st2, sp3 > }
    object { plant translate < xx, st2, sp4 > }
    object { plant translate < xx, st2, sp5 > }
    #declare xx = xx-2*sps ;
  #end
}

#include "gardener.inc"

#declare  g_ghz1 = 0.5*sf1 + 0.5*sf2 ;
#declare  g_ghz2 = 0.5*sf3 + 0.5*sf4 ;

#declare  g_ghx1 = 0.2*se1 + 0.8*sw1 ;
#declare  g_ghx2 = 0.5*se1 + 0.5*sw1 ;
#declare  g_ghx3 = 0.7*se1 + 0.3*sw1 ;

#declare  g_shx5 = flx1 + 15 ;  // behind west door
#declare  g_shy5 = fly2      ;
#declare  g_shz5 = flz1 - 45 ;

#declare  g_shx6 = win0c     ;  // behind upper west window
#declare  g_shy6 = fly4      ;
#declare  g_shz6 = flz4 + 15 ;

#declare  g_shx7 = win1c     ;  // behind upper east window
#declare  g_shy7 = fly4      ;
#declare  g_shz7 = flz4 + 15 ;

#declare  g_shx8 =  -20      ;  // behind south door
#declare  g_shy8 =    0      ;
#declare  g_shz8 = flz4 + 15 ;

#declare  g_shx9 = win0c     ; // behind lower west window
#declare  g_shy9 =    0      ;
#declare  g_shz9 = flx4 + 15 ;

#declare  g_shxa =    0      ;  // near datum
#declare  g_shya =    0      ;
#declare  g_shza =    0      ;

#declare  g_shxb = dex-15    ;  // behind east door
#declare  g_shyb =    0      ;
#declare  g_shzb = dez-15    ;

#declare  gardeners = union {
  object { gardener               translate < g_ghx1,      0, g_ghz1 > }
  object { gardener               translate < g_ghx3,      0, g_ghz1 > }
  object { gardener               translate < g_ghx2,      0, g_ghz2 > }

  object { gardener rotate  90*y  translate < g_shx5, g_shy5, g_shz5 > }
  object { gardener               translate < g_shx6, g_shy6, g_shz6 > }
  object { gardener               translate < g_shx7, g_shy7, g_shz7 > }
  object { gardener               translate < g_shx8, g_shy8, g_shz8 > }
  object { gardener               translate < g_shx9, g_shy9, g_shz9 > }
  object { gardener rotate -90*y  translate < g_shxa, g_shya, g_shza > }
  object { gardener rotate -90*y  translate < g_shxb, g_shyb, g_shzb > }
}

// east shed ------------------------------------------------------------

// southwest corner of east shed body
#declare eshwx = ghcx3  + 56   ; //
#declare eshsz = shz0   + 20   ; //

// northeast corner of east shed body 
#declare eshex = eshwx + 164.0 ; //
#declare eshnz = eshsz + 120.0 ; //

// center of east shed 
#declare eshcx = 0.5 * ( eshwx + eshex ) ;
#declare eshcy = 100.0         ; //

#declare eshrn = eshnz + 12    ; //
#declare eshrs = eshsz - 12    ; //

#declare eshedroof = union { 
  merge {
    box { <  96,  -4, eshrs>, <  0,  0, eshrn> rotate -12*z }
    box { < -96,  -4, eshrs>, <  0,  0, eshrn> rotate  12*z }
    finish { ambient 0.5 diffuse 0.7 } pigment { RoofColor }
  }
  merge {
    box { <  96,  -1, eshrs>, < -9, 99, eshrn> rotate -12*z }
    box { < -96,  -1, eshrs>, <  9, 99, eshrn> rotate  12*z }
    pigment { Invisible } 
  }
  translate < eshcx, eshcy, 0 >
}

#declare eshed = union {
  difference { 
    box { < eshwx, 0, eshsz >, < eshex, eshcy, eshnz > }
    object { eshedroof }
    finish { ambient 0.5 diffuse 0.7 } pigment { WallColor } 
  }
  object { eshedroof }
}

// north tree -----------------------------------------------------------

#declare ntrcx = eshex + 150.0 ;  // tree trunk center e-w
#declare ntrcz = eshnz - 20.0  ;  // tree trunk center n-s

#declare ntry0 = 0.0           ;  // tree bottom
#declare ntry1 =  10.0 * 12.0  ;  // tree foliage bottom
#declare ntry2 =  15.0 * 12.0  ;  // tree foliage middle
#declare ntay2 = ntry2 - 0.01  ;  // tree foliage middle
#declare ntry3 = 100.0 * 12.0  ;  // tree foliage middle
#declare ntay3 = ntry3 - 0.01  ;  // tree foliage middle
#declare ntry4 = 130.0 * 12.0  ;  // tree top
#declare ntrr0 = 18.0          ;  // trunk radius
#declare ntrr1 = 12.0*12.0     ;  // foliage radius
#declare ntrr2 = 0.5*ntrr1     ;  // foliage radius

#declare ntree = union {
  cone { < ntrcx, ntry0, ntrcz >, ntrr0 < ntrcx, ntry4, ntrcz >, 0 
    finish { ambient 0.1 diffuse 0.7 } pigment { WoodColor } }
  merge {
    cone { < ntrcx, ntry1, ntrcz >, 0      < ntrcx, ntry2, ntrcz >, ntrr1 }
    cone { < ntrcx, ntay2, ntrcz >, ntrr1  < ntrcx, ntry3, ntrcz >, ntrr2 }
    cone { < ntrcx, ntay3, ntrcz >, ntrr2  < ntrcx, ntry4, ntrcz >, 0     }
    pigment { TreeGreen }
  }
}

// neighbors ---------------------------------------------------------------

#declare nbrdx = 38.0*12.0     ;
#declare nbrdz = 48.0*12.0     ;
#declare nbrx1 = 460.0         ;
#declare nbrx2 = nbrx1+nbrdx   ;
#declare nbrx3 = nbrx1+1000.0  ;
#declare nbrx4 = nbrx3+nbrdx   ;
#declare nbry1 = 20.0*12.0     ;
#declare nbrz1 = 360.0         ;
#declare nbrz2 = nbrz1+nbrdz   ;

#declare neighbors = union {
  box { < nbrx1, 0, nbrz1 >, < nbrx2, nbry1, nbrz2 > }
  box { < nbrx3, 0, nbrz1 >, < nbrx4, nbry1, nbrz2 > }
  finish { ambient 0.5 diffuse 0.7 } pigment { Gray60 }
}

// whole scene -------------------------------------------------------------

#declare wholescene = union {
  object { lawn        }
  object { hedgefence  }
  object { allsteps    }
  object { concrete    }
  object { shed        }
  object { alldoors    }
  object { waterdoor   }
  object { frontvent   }
  object { covering    }
  object { shedfloor   }
  object { innersteps  }
  object { roof        }
  object { shedwindows }  
  object { pipetree    }
  object { hoops       }
  object { shelves     }
  object { shedvents   }  
  // object { shedlights  }  // inside lights
  object { gardeners   }
}

